//---------------------------------------------------------------------------
// MTZ_AUF.c
//   CREATE : 2007/08/11 YOUMEI
//   UPDATE : 2007/11/11 YOUMEI
//---------------------------------------------------------------------------
#include <windows.h>

#include "filter.h"
#include "MTZ_AUF.h"
#include "ext_func.h"


// NOTE: {ȂC̃\[XȂ̂ŁARgAEg/**/̂ݎgׂAʓ|Ȃ̂//̃}}

//---------------------------------------------------------------------------
// tB^\̒`
//---------------------------------------------------------------------------
#define	TRACK_N	0
#define	CHECK_N	0

FILTER_DLL sOwnFilter = {
	FILTER_FLAG_INTERLACE_FILTER|FILTER_FLAG_EX_INFORMATION|FILTER_FLAG_NO_CONFIG,
																// flag
	0,0,														// x, y
	"AUF̃[hɎs܂",								// name
	TRACK_N,NULL,NULL,											// track_n, track_name, track_default
	NULL,NULL,													// track_s, track_e
	CHECK_N,NULL,NULL,											// check_n, check_name, check_default
	NULL,														// 
	NULL,														// 
	NULL,														// 
	NULL,														// 
	NULL,														// 
	NULL,NULL,													// track, check
	NULL,														// ex_data_ptr
	0,															// ex_data_size
	"AviUtlAUFvOC𕡐XbhAUF Ver. 0.92.00 created by YOUMEI",
																// information
	NULL,														// 
	NULL,														// 
	NULL,														// exfunc
	NULL,														// hwnd
	NULL,														// dll_hinst
	NULL,														// ex_data_def
	NULL
};

//---------------------------------------------------------------------------

HMODULE					hmDstAuf[THREAD_NUM];					// aufW[nh
FILTER_DLL*				lpsDstFilter[THREAD_NUM];				// GetFilterTableŎ擾\̂ւ̃|C^
HANDLE					hThread[THREAD_NUM];					// Xbhnh
HANDLE					hCopyOfEndEvent[THREAD_NUM];			// XbhICxg̃Rs[
TCHAR					lpszStartEventName[THREAD_NUM][_MAX_PATH];
																// JnCxg
TCHAR					lpszEndEventName[THREAD_NUM][_MAX_PATH];// ICxg
DWORD					dwThreadID[THREAD_NUM];					// XbhID(gp)
BOOL					bIsLibLoaded = FALSE;					// Cu[h`FbNtO
HINSTANCE				hDllInstance;							// DLLCX^Xnh
FILTER_THREAD_INFO		sFilterThreadInfo[THREAD_NUM];			// tB^Xbh\
EXFUNC					extfunc_override;						// O֐I[oChp

//---------------------------------------------------------------------------
BOOL __stdcall DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lp)
{
	hDllInstance = hInstance;
	return TRUE;
}

//---------------------------------------------------------------------------
// DLLɂOJI/F
//---------------------------------------------------------------------------
FILTER_DLL __declspec(dllexport) * __stdcall GetFilterTable( void )
{
	BOOL	bRet = TRUE;

	if( bIsLibLoaded == FALSE )
	{
		// Cu[h
		bRet = LoadAufLibrary(hDllInstance);
	}

	if( bRet == TRUE && lpsDstFilter[REP_THREAD_NO] )
	{
		// ΏAUF̐U
		sOwnFilter = *lpsDstFilter[REP_THREAD_NO];

		// Kvȉӏ݂̂AUF̊֐Ăяo悤ɂւ
		sOwnFilter.func_exit		= func_exit;
		sOwnFilter.func_init		= func_init;
		sOwnFilter.func_proc		= func_proc;
		sOwnFilter.func_save_end	= func_save_end;
		sOwnFilter.func_save_start	= func_save_start;
		sOwnFilter.func_update		= func_update;
		sOwnFilter.func_is_saveframe= func_is_saveframe;


		// NOTE: ̊֐͂ւȂ(= WndProc1Xbĥ݌ĂԁAĂяoWindowHandle2dɌq)
//		sOwnFilter.func_WndProc		= func_WndProc;
	}

	return &sOwnFilter;
}

//---------------------------------------------------------------------------
// \̓̊֐|C^ɂJI/F
//---------------------------------------------------------------------------
BOOL func_init( FILTER *fp )
{
	int		i;
	BOOL	bRet = TRUE;
	DWORD	dwProcID = GetCurrentProcessId();

	if( bIsLibLoaded == FALSE )
	{
		// ꃉCu[hĂȂꍇp
		bRet &= LoadAufLibrary(hDllInstance);
	}

	for( i = 0; i < THREAD_NUM; i++ )
	{
		if( hThread[i] == NULL )
		{
			// Xbh쐬
			wsprintf( lpszStartEventName[i], "%s(%d)%08lx%08lx", START_EVENT_NAME, i, dwProcID, hDllInstance );
			wsprintf( lpszEndEventName  [i], "%s(%d)%08lx%08lx", END_EVENT_NAME  , i, dwProcID, hDllInstance );

			sFilterThreadInfo[i].uiThreadNum = i;
			sFilterThreadInfo[i].hStartEvent = CreateEvent( NULL, TRUE, FALSE, lpszStartEventName[i]);
			sFilterThreadInfo[i].hEndEvent = CreateEvent( NULL, TRUE, FALSE, lpszEndEventName[i]);

			hCopyOfEndEvent[i] = sFilterThreadInfo[i].hEndEvent;

			sFilterThreadInfo[i].bExitFlag = FALSE;

			hThread[i] = CreateThread( NULL,
									0,
									ThreadProc,
									&sFilterThreadInfo[i],
									0,
									&dwThreadID[i]);
		}

		// ̊֐Ăяo
		if( lpsDstFilter[i] && lpsDstFilter[i]->func_init )
		{
			bRet &= lpsDstFilter[i]->func_init(fp);
		}
	}

	// O֐pNeBJZNVp
	InitializeCriticalSection(&cs);

	// O֐I[o[Ch
	// NOTE: AVIUTL̏Versionł͂̃I[o[Ch삪삵Ȃ\
	ext_func = fp->exfunc;	// |C^Rs[
	extfunc_override = *ext_func;
	extfunc_override.get_ycp_filtering		 = get_ycp_filtering;
	extfunc_override.get_ycp_filtering_cache = get_ycp_filtering_cache;
	fp->exfunc = &extfunc_override;

	return bRet;
}

BOOL func_exit( FILTER *fp )
{
	BOOL bRet = TRUE;
	int i;

	// ̊֐Ăяo
	for( i = 0; i < THREAD_NUM; i++ )
	{
		if( lpsDstFilter[i] && lpsDstFilter[i]->func_exit )
		{
			bRet &= lpsDstFilter[i]->func_exit(fp);

			// XbhIJn
			ResetEvent(sFilterThreadInfo[i].hEndEvent);

			// XbhI
			sFilterThreadInfo[i].bExitFlag = TRUE;

			SetEvent(sFilterThreadInfo[i].hStartEvent);
		}
	}

	// XbhI҂
	WaitForMultipleObjects( THREAD_NUM, hCopyOfEndEvent, TRUE, INFINITE);

	// XbhY
	for( i = 0; i < THREAD_NUM; i++ )
	{
		hThread[i]  = NULL;
	}

	// Cu
	for( i = THREAD_NUM - 1; i >= 0 ; i-- )
	{
		if( hmDstAuf[i] )
		{
			FreeLibrary(hmDstAuf[i]);
		}
	}

	bIsLibLoaded = FALSE;

	return bRet;
}

BOOL func_proc( FILTER *fp, FILTER_PROC_INFO *fpip )
{
	BOOL				bRet = TRUE;
	int					i;

#if !(THREAD_NUM == 2)
	int					nTempHeight, nTempHeightOrg;
#endif

	// dh~p̃|C^
	p_get_ycp_filtering = NULL;
	p_get_ycp_filtering_cache = NULL;

	// ICxgZbg
	for( i = 0; i < THREAD_NUM; i++ )
	{
		ResetEvent(sFilterThreadInfo[i].hEndEvent);
	}

#if THREAD_NUM == 2
	// 芸㉺2Ă݂(1/2)
	sFilterThreadInfo[0].psFilter			= fp;		// |C^̂݃Rs[
	sFilterThreadInfo[0].sFilterProc        = *fpip;	// \̂̒lRs[
	sFilterThreadInfo[0].sFilterProc.h      = sFilterThreadInfo[0].sFilterProc.h     / 2;
	sFilterThreadInfo[0].sFilterProc.org_h  = sFilterThreadInfo[0].sFilterProc.org_h / 2;

	SetEvent(sFilterThreadInfo[0].hStartEvent);
//	WaitForSingleObject( hCopyOfEndEvent[0],  INFINITE);

	// 芸㉺2Ă݂(2/2)
	sFilterThreadInfo[1].psFilter			= fp;		// |C^̂݃Rs[
	sFilterThreadInfo[1].sFilterProc        = *fpip;	// \̂̒lRs[
	sFilterThreadInfo[1].sFilterProc.h      = sFilterThreadInfo[1].sFilterProc.h     - sFilterThreadInfo[0].sFilterProc.h;
	sFilterThreadInfo[1].sFilterProc.org_h  = sFilterThreadInfo[1].sFilterProc.org_h - sFilterThreadInfo[0].sFilterProc.org_h;
	// (1/2)ŏGA͔΂
	// NOTE: tB^Ńobt@I[o[Ăꍇ́Aꂼꏈʂ̑̏ʂɐZH\L
	sFilterThreadInfo[1].sFilterProc.ycp_edit = sFilterThreadInfo[0].sFilterProc.ycp_edit + sFilterThreadInfo[0].sFilterProc.h * sFilterThreadInfo[0].sFilterProc.max_w;
	sFilterThreadInfo[1].sFilterProc.ycp_temp = sFilterThreadInfo[0].sFilterProc.ycp_temp + sFilterThreadInfo[0].sFilterProc.h * sFilterThreadInfo[0].sFilterProc.max_w;

	SetEvent(sFilterThreadInfo[1].hStartEvent);
//	WaitForSingleObject( hCopyOfEndEvent[1],  INFINITE);

#else
	// 芸㉺nĂ݂(1/n)
	nTempHeight    = fpip->h     / THREAD_NUM;
	nTempHeightOrg = fpip->org_h / THREAD_NUM;

	sFilterThreadInfo[0].psFilter			= fp;		// |C^̂݃Rs[
	sFilterThreadInfo[0].sFilterProc        = *fpip;	// \̂̒lRs[
	sFilterThreadInfo[0].sFilterProc.h      = nTempHeight    + (fpip->h     - nTempHeight    * THREAD_NUM);
	sFilterThreadInfo[0].sFilterProc.org_h  = nTempHeightOrg + (fpip->org_h - nTempHeightOrg * THREAD_NUM);

	SetEvent(sFilterThreadInfo[0].hStartEvent);

	// 芸㉺nĂ݂(i/n)
	for( i = 1; i < THREAD_NUM; i++ )
	{
		sFilterThreadInfo[i].psFilter			= fp;		// |C^̂݃Rs[
		sFilterThreadInfo[i].sFilterProc        = *fpip;	// \̂̒lRs[
		sFilterThreadInfo[i].sFilterProc.h      = nTempHeight;
		sFilterThreadInfo[i].sFilterProc.org_h  = nTempHeightOrg;
		// (i-1/n)ŏGA͔΂
		// NOTE: tB^Ńobt@I[o[Ăꍇ́Aꂼꏈʂ̑̏ʂɐZH\L
		sFilterThreadInfo[i].sFilterProc.ycp_edit = sFilterThreadInfo[i-1].sFilterProc.ycp_edit + sFilterThreadInfo[i-1].sFilterProc.h * sFilterThreadInfo[i].sFilterProc.max_w;
		sFilterThreadInfo[i].sFilterProc.ycp_temp = sFilterThreadInfo[i-1].sFilterProc.ycp_temp + sFilterThreadInfo[i-1].sFilterProc.h * sFilterThreadInfo[i].sFilterProc.max_w;

		SetEvent(sFilterThreadInfo[i].hStartEvent);
	}
#endif

	// XbhI҂
	WaitForMultipleObjects( THREAD_NUM, hCopyOfEndEvent, TRUE, INFINITE);

	// TODO: Xbhfunc_proc̖߂l擾
	//       YEEEɖɂ͂ȂȂł傤(?)

	return bRet;
}


BOOL func_update( FILTER *fp )
{
	int i;
	BOOL bRet = TRUE; // [vɖ߂l=FALSEA[vFALSEԂ悤׍H

	for( i =0; i < THREAD_NUM; i++)
	{
		if( lpsDstFilter[i] )
		{
			if( lpsDstFilter[i]->func_update )
			{
				bRet &= lpsDstFilter[i]->func_update(fp);
			}
		}
	}

	return bRet;
}

// NOTE: WindowHandle2dȂǂɌq̂ŗpȂ
/*
BOOL func_WndProc( HWND hwnd,UINT message,WPARAM wparam,LPARAM lparam,void *editp,FILTER *fp )
{
	int i;
	BOOL bRet = TRUE;

	for( i =0; i < THREAD_NUM; i++)
	{
		if( lpsDstFilter[i] )
		{
			if( lpsDstFilter[i]->func_WndProc )
			{
				bRet &= lpsDstFilter[i]->func_WndProc( hwnd, message, wparam, lparam, editp, fp);
			}
		}
	}

	return bRet;
}
*/

BOOL func_save_start( FILTER *fp,int s,int e,void *editp )
{
	int i;
	BOOL bRet = TRUE;

	for( i =0; i < THREAD_NUM; i++)
	{
		if( lpsDstFilter[i] )
		{
			if( lpsDstFilter[i]->func_save_start )
			{
				bRet &= lpsDstFilter[i]->func_save_start( fp, s, e, editp);
			}
		}
	}

	return bRet;
}

BOOL func_save_end( FILTER *fp,void *editp )
{
	int i;
	BOOL bRet = TRUE;

	for( i =0; i < THREAD_NUM; i++)
	{
		if( lpsDstFilter[i] )
		{
			if( lpsDstFilter[i]->func_save_end )
			{
				bRet &= lpsDstFilter[i]->func_save_end(fp, editp);
			}
		}
	}

	return bRet;
}

BOOL func_is_saveframe( FILTER *fp,void *editp,int saveno,int frame,int fps,int edit_flag,int inter )
{
	int i;
	BOOL bRet = TRUE;

	for( i =0; i < THREAD_NUM; i++)
	{
		if( lpsDstFilter[i] )
		{
			if( lpsDstFilter[i]->func_is_saveframe )
			{
				bRet &= lpsDstFilter[i]->func_is_saveframe(fp, editp, saveno, frame, fps, edit_flag, inter);
			}
		}
	}

	return bRet;
}


//---------------------------------------------------------------------------
// XbhC
//---------------------------------------------------------------------------
static DWORD WINAPI ThreadProc( LPVOID lpParameter )
{
	FILTER_THREAD_INFO* pInfo = (FILTER_THREAD_INFO*) lpParameter;

	while(TRUE)
	{
		// Xbh̎sw܂ő҂
		WaitForSingleObject(pInfo->hStartEvent, INFINITE);

		if( pInfo->bExitFlag == FALSE /*&& pInfo->fp && pInfo->fpip*/)
		{
			// Jn
			pInfo->lpFuncProc(pInfo->psFilter, &(pInfo->sFilterProc));
		}

		// Xbh̎s(VOi)
		ResetEvent(pInfo->hStartEvent);

		// ICXbhɘA(VOi)
		SetEvent(pInfo->hEndEvent);

		// XbhI
		if( pInfo->bExitFlag == TRUE)
		{
			break;
		}
	}
	
	return 0;
}

//---------------------------------------------------------------------------
// gp֐
//---------------------------------------------------------------------------

BOOL LoadAufLibrary(HINSTANCE hInstance)
{
	LPGETFILTERTABLE	lpfnGetFilterTable;						// GetFilterTable|C^
	TCHAR				tcOwnFileName[_MAX_PATH];
	TCHAR				tcPluginFileName[_MAX_PATH];
	LPTSTR				lptszOwnFileName = tcOwnFileName;
	LPTSTR				lptszPluginFileName = tcPluginFileName;
	TCHAR				lpszMsg[sizeof(ERR_MSG_DLL_NOT_FOUND) + _MAX_PATH + 1];

	int		nFileNameLen = 0;
	int		i;
	BOOL	bFuncRet = TRUE;
	BOOL	bLoadLibRet;

	for( i = 0; i < THREAD_NUM; i++)
	{
		hmDstAuf[i] = NULL;
		lpsDstFilter[i] = NULL;
	}

	// t@C擾
	GetModuleFileName( hInstance, lptszOwnFileName, _MAX_PATH);
	nFileNameLen = 0;
	if( (nFileNameLen = lstrlen(lptszOwnFileName)) < MIN_AUF_FILE_NAME_LEN )
	{
		// Zꍇُ͈ƌȂďI
		return FALSE;
	}
	
	// ⓚpɊgq폜
	lptszOwnFileName[nFileNameLen - MIN_AUF_FILE_NAME_LEN + 1] = '\0';

	for( i =0; i < THREAD_NUM; i++)
	{
		bLoadLibRet = FALSE;

		wsprintf( lptszPluginFileName, STR_PLUGIN_FILE_NAME, lptszOwnFileName, i);

		// }`XbhΉDLLl2Ǎ
		// TODO: vĊmF
		hmDstAuf[i] = LoadLibrary(lptszPluginFileName);
		if( hmDstAuf[i] )
		{
			lpfnGetFilterTable = (LPGETFILTERTABLE) GetProcAddress( hmDstAuf[i], STR_GETFILTERTABLE_FUNC_NAME );

			if( lpfnGetFilterTable )
			{
				lpsDstFilter[i] = lpfnGetFilterTable();
				if(lpsDstFilter)
				{
					sFilterThreadInfo[i].lpFuncProc = lpsDstFilter[i]->func_proc;
					bLoadLibRet = TRUE;
				}
			}
		}

		if( bLoadLibRet == FALSE )
		{
			wsprintf( lpszMsg, "%s%s", ERR_MSG_DLL_NOT_FOUND, lptszPluginFileName);
			MessageBox( HWND_DESKTOP, lpszMsg, ERR_TITLE, MB_OK);
		}

		bFuncRet &= bLoadLibRet;
	}

	// IɂvOC[hłȂꍇ͑Sĉ
	if( bFuncRet == FALSE )
	{
		for( i = THREAD_NUM - 1; i >= 0 ; i--)
		{
			FreeLibrary(hmDstAuf[i]);
			hmDstAuf[i] = NULL;
		}
	}

	// ŏIIɃO[oϐɃ[hۂݒ/ێ
	bIsLibLoaded = bFuncRet;

	return bFuncRet;
}
