
#include <config.h>
#include "command.h"
#include "data.h"
#include "draw.h"
#include "graph.h"

int
main(int argc, char **argv)
{
  ag_option(argc, argv);
  ag_read_data();

  ag_draw_init();
  ag_graph_init();
  ag_command_init();

  ag_make_graph();
  ag_draw();

  ag_loop();
  return 0;
}

void
ag_exit(void)
{
  ag_draw_end();
  ag_graph_end();
  ag_data_end();
  exit(0);
}
