
#ifndef GRAPH_H
#define GRAPH_H

#include <math.h>
#ifdef HAVE_FLOAT_H
#include <float.h>
#endif
#include "ag.h"

#define AG_EPSILON 1e-9		/* > 1**(-31) */
#ifdef DBL_MAX_10_EXP
#define AG_MAX_10_EXP DBL_MAX_10_EXP
#else
#define AG_MAX_10_EXP 308
#endif
#ifdef DBL_MAX
#define AG_MAX DBL_MAX
#else
#define AG_MAX 1.7976931348623157E+308
#endif
#define AG_POS_MAX 10000	/* < 1**15 */

#define AG_AXIS_X   1
#define AG_AXIS_Y   2
#define AG_AXIS_SUB 4
#define AG_MAX_SCALE 100
#define AG_MAX_LIMIT 100

#define AG_G2X(x) (AgW * ((x) - AgXMin) / (AgXMax - AgXMin))
#define AG_G2Y(y) (AgH * ((y) - AgYMin) / (AgYMax - AgYMin))
#define AG_G2X_POS(x) AG_X_POS(AG_G2X(x))
#define AG_G2Y_POS(y) AG_Y_POS(AG_G2Y(y))
#define AG_X_POS(x) ((AG_pos)rint(x))
#define AG_Y_POS(y) ((AG_pos)rint(y))

#ifndef HAVE_RINT
#define rint(x) floor((x) + 0.5)
#endif

extern double AgXMin, AgXMax, AgYMin, AgYMax;
extern AG_bool AgDefineXLimit, AgDefineYLimit;
extern AG_bool AgXLog, AgYLog;
extern AG_scale AgXScale, AgXSubScale, AgYScale, AgYSubScale;
extern double AgZoomX0, AgZoomY0, AgZoomX1, AgZoomY1;
extern AG_limit AgLimitStack[];
extern int AgNLimitStack;

extern void ag_graph_init(void);
extern void ag_graph_end(void);
extern void ag_make_graph(void);
extern void ag_make_scale(void);
extern void ag_make_data(int active);
extern void ag_auto_scale(AG_axis axis);
extern void ag_push_limit(void);
extern AG_bool ag_pop_limit(void);
extern void ag_zoom_graph(AG_bool push);

#endif
