
#ifndef DRAW_H
#define DRAW_H

#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif
#include "ag.h"

#ifdef HAVE_START_COLOR
#define AG_HAVE_COLOR
#endif
#if defined(HAVE_SETENV) || defined(HAVE_PUTENV)
#define AG_CHANGE_TERM
#endif

#define AG_OFFSET_X0 6
#define AG_OFFSET_X1 13
#define AG_OFFSET_Y0 1
#define AG_OFFSET_Y1 2

#define AG_COLORS        8
#define AG_COLOR_BLACK   0
#define AG_COLOR_RED     1
#define AG_COLOR_GREEN   2
#define AG_COLOR_YELLOW  3
#define AG_COLOR_BLUE    4
#define AG_COLOR_MAGENTA 5
#define AG_COLOR_CYAN    6
#define AG_COLOR_WHITE   7

#define AG_MAX_HEIGHT 200

#define AG_CROP_MESSAGE "Crop: RET) select, c) cancel "
#define AG_AXIS_MESSAGE "%c-Axis: l) %s, r) reverse, a) auto scale, z) zoom "
#define AG_QUIT_MESSAGE "Quit ? (y/n)"
#define AG_HELP_MESSAGE "Help: SPC) fore, b) back, q) quit "
#define AG_LIST_MESSAGE "List: SPC) fore, b) back, n) next, p) prev, q) quit "

#define bold()      attron(A_BOLD)
#define boldend()   attroff(A_BOLD)
#define under()     attron(A_UNDERLINE)
#define underend()  attroff(A_UNDERLINE)
#ifdef AG_HAVE_COLOR
#define rev()       (AgHasColor ? attron(COLOR_PAIR(2)) : attron(A_REVERSE))
#define revend()    (AgHasColor ? attron(COLOR_PAIR(1)) : attroff(A_REVERSE))
#define color(x)    (AgHasColor ? attron(COLOR_PAIR(((x) + 3))) : 0)
#define revcolor(x) (AgHasColor ? attron(COLOR_PAIR(((x) + 3 + AG_COLORS))) : attron(A_REVERSE))
#else
#define rev()       attron(A_REVERSE)
#define revend()    attroff(A_REVERSE)
#define color(x)    /**/
#define revcolor(x) rev()
#endif
#define normal()    revend()

extern AG_pos AgX0, AgY0, AgX1, AgY1, AgW, AgH;
extern AG_pos AgCursorX, AgCursorY;
extern AG_pos *AgLabelPos;
extern AG_pos AgHelpPos, AgHelpH, AgListH;
extern AG_bool AgShowMarker, AgShowLine, AgShowGrid;
extern AG_bool AgUseMouse;
#ifdef AG_CHANGE_TERM
extern char AgTerm[AG_MAX_SIZE];
#endif
extern AG_marker **AgMarker, **AgLine, **AgActiveMarker, **AgActiveLine;
#ifdef AG_HAVE_COLOR
extern short AgForeGround, AgBackGround;
#endif

extern void ag_draw_init(void);
extern void ag_draw_end(void);
extern void ag_center(void);
extern void ag_clear(void);
extern void ag_draw(void);
extern void ag_mouse_init(void);
extern void ag_mouse_end(void);

#endif
