
#ifndef DATA_H
#define DATA_H

#include "ag.h"

#define AG_XG_IGNORE 0
#define AG_XG_EMPTY  1
#define AG_XG_LABEL  2
#define AG_XG_DRAW   3
#define AG_XG_MOVE   4

#define AG_OPT_UNKNOWN 1
#define AG_OPT_REQUIRE 2
#define AG_OPT_INVALID 3

#define AG_DEF_TITLE "Ascii Graph"
#define AG_DEF_XNAME "X-Axis"
#define AG_DEF_YNAME "Y-Axis"
#define AG_DEF_MARKERS "xo*+@"
#define AG_MAX_COLOR 100

extern char AgTitle[], AgXName[], AgYName[];

extern AG_data *AgData;
extern int AgNData;
extern char **AgFile;
extern int AgNFile;

extern void ag_usage(char *opt, int err);
extern void ag_option(int argc, char **argv);
extern void ag_read_data(void);
extern void ag_read_file(char *file);
extern void ag_data_end(void);

#endif
