
#ifndef COMMAND_H
#define COMMAND_H

#include "ag.h"

#define AG_MODES      6
#define AG_MODE_GRAPH 0
#define AG_MODE_CROP  1
#define AG_MODE_AXIS  2
#define AG_MODE_QUIT  3
#define AG_MODE_HELP  4
#define AG_MODE_LIST  5

#define AG_MOUSE_DOWN1 0
#define AG_MOUSE_DOWN2 1
#define AG_MOUSE_DOWN3 2
#define AG_MOUSE_UP    3
#define AG_MOUSE_CLICK 4

#define AG_CNTRL_A 1
#define AG_CNTRL_B 2
#define AG_CNTRL_C 3
#define AG_CNTRL_D 4
#define AG_CNTRL_E 5
#define AG_CNTRL_F 6
#define AG_CNTRL_G 7
#define AG_CNTRL_H 8
#define AG_CNTRL_I 9
#define AG_CNTRL_J 10
#define AG_CNTRL_K 11
#define AG_CNTRL_L 12
#define AG_CNTRL_M 13
#define AG_CNTRL_N 14
#define AG_CNTRL_O 15
#define AG_CNTRL_P 16
#define AG_CNTRL_Q 17
#define AG_CNTRL_R 18
#define AG_CNTRL_S 19
#define AG_CNTRL_T 20
#define AG_CNTRL_U 21
#define AG_CNTRL_V 22
#define AG_CNTRL_W 23
#define AG_CNTRL_X 24
#define AG_CNTRL_Y 25
#define AG_CNTRL_Z 26
#define AG_ESC     27
#define AG_DEL     127

#define AG_KEY_ESC  0x100
#define AG_KEY_ESCB 0x200
#define AG_KEY_ESCD 0x400
#define AG_KEY_UNKNOWN 0x800
#define AG_KEY_UP    (AG_KEY_ESCB | 'A')
#define AG_KEY_DOWN  (AG_KEY_ESCB | 'B')
#define AG_KEY_RIGHT (AG_KEY_ESCB | 'C')
#define AG_KEY_LEFT  (AG_KEY_ESCB | 'D')
#define AG_KEY_MOUSE (AG_KEY_ESCB | 'M')

typedef struct {
  int key;
  void (*func)();
} AG_command;

extern int AgMode;
extern int AgActive;
extern AG_axis AgAxis;
extern AG_marker AgNext;
extern AG_marker AgList;
extern double AgZoomRatio;
extern char *AgHelp[];

extern void ag_command_init(void);
extern void ag_loop(void);
extern int ag_getch(void);

#endif
