
#ifndef AG_H
#define AG_H

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_STRING_H
#include <string.h>
#else
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#endif

typedef char   AG_bool;
typedef short  AG_pos;
typedef char   AG_axis;

typedef struct {
  double xmin;
  double xmax;
  double ymin;
  double ymax;
} AG_limit;

typedef struct {
  int data;
  int set;
  int point;
  char marker;
} AG_marker;

typedef struct {
  double *x;
  double *y;
  AG_pos *pos_x;
  AG_pos *pos_y;
  int n;
} AG_dataset;

typedef struct {
  AG_dataset *set;
  int nset;
  char *label;
  char marker;
  short color;
  AG_bool show_marker;
  AG_bool show_line;
} AG_data;

typedef struct {
  AG_pos *pos;
  char **label;
  int n;
} AG_scale;


#define AG_MAX_SIZE 256

#undef FALSE
#define FALSE 0
#undef TRUE
#define TRUE 1
#define AG_UNDEF -1

#define AG_DEF(x) ((x) != AG_UNDEF)

#define AG_NEW(type) ((type *)malloc(sizeof(type)))
#define AG_NEW_N(type, n) ((type *)malloc(sizeof(type) * (n)))
#define AG_RESIZE(ptr, type, n) ((type *)realloc((void *)(ptr), sizeof(type) *(n)))
#define AG_FREE(ptr) free((void *)ptr)

extern void ag_exit(void);

#endif
